<?php 

/*
Plugin Name: Overplace Widgets
Plugin URI: http://developers.overplace.com
Description: Overplace Widgets
Version: 1.86
Author: Overplace Developers
Author URI: http://developers.overplace.com
*/

require_once ('overplace-widget-css-generator.php');
//require_once ('overplace_widget_autoupdate.php');
require 'plugin-update-checker-4.2/plugin-update-checker.php';
$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
	'http://developers.overplace.com/plugin-update-self-hosted/overplace-widget/plugin-update-checker-4.2/examples/plugin.json',
	__FILE__,
	'overplace-widget'
);

/**
 * Main Class - Overplace Widget
 */
class Overplace_Widget_Options {
    
    /**
     * Options grafiche
     * @var array
     */
    public $options;
    
    /**
     * Options moduli
     * @var array
     */
    public $modules_options;
    
    /**
     * Url javascript per renderizzazione widget
     * @var string
     */
    const ovp_widgets_js = '//www.overplace.com/widgets_js/js/ovp_widget.js';
        
    /**
     * Versiona attuale di questo plugin
     * @var string
     */
    const current_version = '1.86';
    
    /**
     * Url server per controllo versione e update
     * @var string
     */
    const self_hosted_url = 'http://www.overplace.com/ws/wordpress_update.php?plugin=overplace_widget';
    
    /**
     * Istanza di questo oggetto
     * @var Overplace_Widget_Options
     */
    private static $instance = null;

    /**
     * Flag che indica che il javascript del widget è stato inserito
     * @var bool
     */
    private $js_inserted = false;
    
    /**
     * Flag che indica che lo snippet javascript di configurazione moduli
     * è stato inserito nel dom
     * @var bool
     */
    private $config_inserted = false;
    
    /**
     * Moduli invocati dallo shortcode
     * @var array
     */
    private $shortcode_active_modules = array();
        
    /**
     * Ritorna un'istanza di questa classe in singleton
     * @access	public
     * 
     * @return  Overplace_Widget_Options
     */
    public static function get_instance (){
        if (null == self::$instance){
            self::$instance = new self();
        }
        return self::$instance;
    }
  
    /**
     * Inzializzazione hooks, filters e actions
     * @access	private
     * @see		Overplace_Widget_Options::get_instance()
     */
    private function __construct (){
    	// Add the page to the admin menu
	    add_action('admin_menu', array(&$this, 'add_page'));
	    
	    // Register page options
	    add_action('admin_init', array(&$this, 'register_page_options'));
	    //add_action('admin_init', array($this,'ovp_widget_au'));
	    
	    add_action('genera_css_file', array($this, 'genera_file_css'));
	     
	    // Register javascript
	    add_action('admin_enqueue_scripts', array($this, 'enqueue_admin_js'));
	    
	    add_action('admin_head', array($this, 'ovp_add_tinymce'));
	    
	    add_filter('upload_mimes', array($this, 'add_css_mime_types'));
	    add_filter('post_mime_types', array($this, 'modify_css_mime_types'));
	    add_filter('filter_modules_options', array($this, 'filter_modules_vars'), 10, 1);
	    add_filter('widget_text', 'do_shortcode');

	    // Get registered option
	    $this->options = get_option('ovpw_settings_options');
	    
	    $this->modules_options = json_decode(unserialize(get_option('ovpw_modules_options')), true);
	    add_shortcode('overplace_widget', array($this, 'render_overplace_widget'));
	    
	    register_activation_hook(__FILE__, array($this, 'ovpw_register_plugin'));
	    register_deactivation_hook(__FILE__, array($this, 'ovpw_unregister_plugin'));
    }
   
    /**
     * Registro pulsante Widget nei tinymce di post e pagine
     * @access	public
     */
    public function ovp_add_tinymce (){
    	global $typenow;
    	
    	// only on Post Type: post and page
    	if(!in_array($typenow, array('post', 'page'))){
    		return;
    	}
    	
    	wp_enqueue_style('wp-admin-widget-gen', plugins_url('css/overplace-widget-tiny-icon.css',  __FILE__));
    	add_filter('mce_external_plugins', array($this, 'ovp_add_tinymce_plugin'));
		add_filter('mce_buttons', array($this, 'ovp_add_tinymce_button'));
    }
    
    /**
     * Genera un file css in base ai parametri passati
     * @access	public
     * 
     * @param 	array 	$params
     */
    public function genera_file_css ($params){
    	$upload_dir = wp_upload_dir();
    	$css = new css_generator($params);
    	if (!empty($css->output)){
    		$fname = uniqid('ovp_style_'.time().'_').'.css';
			file_put_contents($upload_dir['path'].'/'.$fname, $css->output);
			if (file_exists($upload_dir['path'].'/'.$fname)){
				update_option('ovpw_generated_css', $upload_dir['url'].'/'.$fname);
			}
    	}
    }
    
    /**
     * Renderizzazione shortcode
     * @access	public
     * 
     * @param 	array 	$args
     * 
     * @return 	string
     */
    public function render_overplace_widget ($args){
    	if ((isset($args['type']) && !empty($args['type'])) && (isset($args['ovp_id']) && !empty($args['ovp_id']))){
    		if (isset($_SERVER['HTTPS']) && ($_SERVER['HTTPS'] == 'on' || $_SERVER['HTTPS'] == 1) || isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https'){
    			$protocol = 'https:';
    		}else {
    			$protocol = 'http:';
    		}
    		
    		$out = $this->js_inserted ? '' : '<script src="' . $protocol . self::ovp_widgets_js . '" type="text/javascript"></script>';
    		$this->js_inserted = true;
    		
    		$id_vetrina = esc_attr($args['ovp_id']);
    		
    		$moduli = array();
    		
    		$generated_css = get_option('ovpw_generated_css');
    		
    		if (strpos($args['type'], ',') !== false){
    			$moduli = explode(',', $args['type']);
    		}else {
    			$moduli[] = $args['type'];
    		}
    		$nr = count($moduli);

    		for ($i = 0; $i < $nr; $i++){
    			$out.= '<div id="'.$moduli[$i].'" ovp_id="'.$args['ovp_id'].'">';
    			$this->shortcode_active_modules[] = $moduli[$i];
    			if (!empty($this->options['file'])){
    				$out.= '<!-- '.$this->options['file'].' -->';
    			}else if (!empty($generated_css)){
    				$out.= '<!-- '.$generated_css.' -->';
    			}
    			$out.= '</div>';
    		}
    		add_action('get_footer', array($this, 'render_footer_json_object'));
    		return $out;
    	}
    }
    
    /**
     * Renderizza le options dei moduli chiamati dal widget nel footer
     * @access	public
     */
    public function render_footer_json_object (){
    	if (!empty($this->shortcode_active_modules) && !$this->config_inserted){
    		$this->config_inserted = true;
    		$nr = count($this->shortcode_active_modules);
    		$out = '<script type="text/javascript">'."\n".
    					'var ovp_widget_configuration = {'."\n";
    		for ($i = 0; $i < $nr; $i++){
    			$mod = $this->shortcode_active_modules[$i];
    			if (isset($this->modules_options[$mod])){
    				$out .= $mod . ' : '. json_encode($this->modules_options[$mod]) . ',' . "\n";
    			}
    		}
    		$out .= '};</script>';
    		echo $out;
    	}
    }
    
	/**
	 * Registrazione pagine admin
	 * @access	public
	 */
	public function add_page (){
	    add_menu_page('Overplace Widget', 'Overplace Widget', 'manage_options', 'ovpw_settings_options', array($this, 'display_page'));
	   	add_submenu_page('ovpw_settings_options', 'Modifica Css', 'Modifica Css', 'manage_options', 'ovpw_edit_css', array($this, 'display_editor_css'));
	   	add_submenu_page('ovpw_settings_options', 'Impostazioni Moduli', 'Impostazioni Moduli', 'manage_options', 'ovpw_manage_options', array($this, 'display_module_page'));
	}
	 
	/**
	 * Option page stile e caratteristiche grafiche
	 * @access	public
	 */
	public function display_page (){
		if (isset($_REQUEST['settings-updated']) && $_REQUEST['settings-updated'] == 'true'){
			echo '<div class="updated">
			        	<p>Salvataggio Riuscito!</p>
			    	</div>';
		}else if (isset($_REQUEST['settings-updated']) && $_REQUEST['settings-updated'] == 'false'){
			echo '<div class="error">
			        	<p>Salvataggio Fallito!</p>
			    	</div>';
		}
		echo '<div class="wrap"><form method="post" action="options.php">';
		settings_fields('ovpw_settings_options');
		do_settings_sections('ovpw_settings_options');
		submit_button();
		echo '</form></div>';
	}
	
	/**
	 * Option page configurazione moduli
	 * @access	public
	 */
	public function display_module_page (){
		$this->display_section();
		if (!empty($_POST['operation']) && $_POST['operation'] == 'salva_impostazioni_moduli' && !empty($_POST['ovpw_modules_options'])){
			$post = apply_filters('filter_modules_options', $_POST);
			update_option('ovpw_modules_options', serialize(json_encode($post['ovpw_modules_options'])));
			$this->modules_options = json_decode(unserialize(get_option('ovpw_modules_options')), true);
			echo '<div class="updated">
			        	<p>Salvataggio Riuscito!</p>
			    	</div>';
		}
		
		if (!empty($_POST['operation']) && $_POST['operation'] == 'reset_impostazioni_moduli'){
			$this->set_modules_default_option();
			$this->modules_options = json_decode(unserialize(get_option('ovpw_modules_options')), true);
			echo '<div class="updated">
			        	<p>Valori originali ripristinati!</p>
			    	</div>';
		}
		
		$options = $this->modules_options;
		include('overplace-widget-modules-admin-form.php');
	}
	
	/**
	 * Option page editor css
	 * @access	public
	 */
	public function display_editor_css (){
		if (isset($_REQUEST['operation']) && $_REQUEST['operation'] == 'edit_ovp_widget_style' && isset($_REQUEST['css_style'])){
			$generated_css = get_option('ovpw_generated_css');
			if (!empty($this->options['file'])){
				$css_file_url = $this->options['file'];
			}else if (!empty($generated_css)){
				$css_file_url = $generated_css;
			}
			
			$fname = end(explode('/', $css_file_url));
			
			$upload_dir = wp_upload_dir();
			
			$css = stripslashes($_REQUEST['css_style']);
			
			file_put_contents($upload_dir['path'].'/'.$fname, $css);
			if (file_exists($upload_dir['path'].'/'.$fname)){
				update_option('ovpw_generated_css', $upload_dir['url'].'/'.$fname);
				echo '<div class="updated">
			        	<p>Salvataggio Riuscito!</p>
			    	</div>';
			}else {
				echo '<div class="error">
			        	<p>Salvataggio Non Riuscito!</p>
			    	</div>';
			}
		}
		$this->display_section();
		$css = $this->get_generated_css();
		$txt_disabled = empty($css) ? 'disabled' : '';
		echo '<div class="wrap"><br class="clear">
							<div id="col-container">
								<div id="col">
									<div class="col-wrap"><h2>Modifica manuale del foglio di stile associato ai widget Overplace</h2><form method="post">';
		echo '<textarea class="preview_css_box" name="css_style" '.$txt_disabled.'>';
		echo $css;
		echo '</textarea>';
		echo '<input type="hidden" name="operation" value="edit_ovp_widget_style">';
		echo '<p><strong>Le modifiche al foglio di stile saranno sovrascritte in caso di utilizzo del configuratore di Caratteristiche Grafiche</strong></p>';
		echo '<input type="submit" value="Salva" class="button button-primary button-hero">';
		echo '</form></div></div></div></div>';
	}
	
	/**
	 * Inizializzazione javascript e colorpicker
	 * @access	public
	 */
	public function enqueue_admin_js (){
		wp_enqueue_media();
	    wp_enqueue_script('ovpw_custom_js', plugins_url('js/overplace-widget.js', __FILE__), array('jquery', 'wp-color-picker'), '', true);
	    wp_enqueue_style('wp-color-picker');
	}
	
	/**
	 * Accoda il foglio di stile custom per i pannelli di amministrazione
	 * @access	public
	 */
	public function display_section (){
		wp_enqueue_style('wp-admin-widget-gen', plugins_url('css/overplace-widget-admin.css', __FILE__));
	}
	
	/**
	 * Controllo su correttezza formale colore
	 * @access	public
	 * 
	 * @param	string	$value
	 * 
	 * @return	bool
	 */
	public function check_color ($value){
		if (preg_match('/^#[a-f0-9]{6}$/i', $value)){
			// if user insert a HEX color with #
			return true;
		}
		
		return false;
	}
	
	/**
	 * Validazione campi options grafiche
	 * @access	public
	 */
	public function validate_options ($fields){
	    $valid_fields = array();
	    
	    // Validate Title Field
	    $file = trim($fields['file']);
	    $valid_fields['file'] = strip_tags(stripslashes($file));
	    
	    $array_color_fields = array(
    		'background', 
    		'header_background', 
    		'header_color', 
    		'body_background',
    		'body_background_secondary', 
// 			'body_separator_width',
//     		'body_separator_color', 
    		'body_success_box_bg', 
    		'body_text_color', 
    		'body_secondary_text_color',
    		'body_boxed_text_color',
    		'body_button_color',
    		'modulo_button_color',
    		'body_button_text_color'
    	);
	    
	    $css_fields = array();
	    
	    foreach ($array_color_fields as $key){			
			// Validate Background Color
		    $color = trim($fields[$key]);
		    $color = strip_tags(stripslashes($color));
		     
		    // Check if is a valid hex color
		    if (FALSE === $this->check_color($color) /*&& $key !== "body_separator_width"*/){
		        // Get the previous valid value
		    	$valid_fields[$key] = isset($this->options[$key]) ? $this->options[$key] : '';
		    } /*else if ($key === 'body_separator_width'){
				
				if (isset($color) && !empty($color)){
					$valid_fields[$key] = $color;
					$css_fields[$key] = $color;
				}
				
			} */else {
		        $valid_fields[$key] = $color;
		        $css_fields[$key] = $color;
		    }
	    }
	    
	    if (!empty($css_fields)){
	    	do_action('genera_css_file', $css_fields);
	    }
	    
	    return apply_filters('validate_options', $fields, $fields);
	}
	
    /**
     * Inizializzazione javscript custom tinymce
     * @access	public
     *  
     * @param 	array 	$plugin_array
     * 
     * @return 	array
     */
    public function ovp_add_tinymce_plugin ($plugin_array){
    	$plugin_array['ovp_widget'] = plugins_url( 'js/ovp_tiny_plugin.js',  __FILE__);
    	$idVetrina = isset($this->options['id_vetrina']) ? strtoupper($this->options['id_vetrina']) : '';
    	echo '<input type="hidden" name="codice_vetrina" value="' . $idVetrina . '" />';    	
    	return $plugin_array;
    }
    
	/**
	 * Aggiunge il pulsante Widget Overplace alla configurazione dell'editor
	 * tiny mce di wordpress
	 * @access	public
	 * 
	 * @param 	array 	$buttons
	 * 
	 * @return 	array
	 */
    public function ovp_add_tinymce_button ($buttons){
    	array_push($buttons, 'ovp_widget_key');
    	return $buttons;
    }
    
    /**
     * Registrazione options grafiche.
     * @access	public
     */
    public function register_page_options (){
	   	/*
    	 * Grafica
    	 */
    	add_settings_section('ovpw_section', 'Caratteristiche Grafiche', array($this, 'display_section'), 'ovpw_settings_options'); // id, title, display cb, page
    	add_settings_field('ovpw_file_field', 'CSS File Esterno', array($this, 'file_settings_field'), 'ovpw_settings_options', 'ovpw_section'); // id, title, display cb, page, section
    	add_settings_field('ovpw_id_vetrina_field', 'Codice Vetrina', array($this, 'id_vetrina_field'), 'ovpw_settings_options', 'ovpw_section'); // id, title, display cb, page, section
    	add_settings_field('ovpw_bg_field', 'Colore di sfondo base', array($this, 'bg_settings_field'), 'ovpw_settings_options', 'ovpw_section'); // id, title, display cb, page, section
    	add_settings_field('ovpw_header_bg_field', 'Colore di sfondo dell\'header', array($this, 'header_bg_settings_field'), 'ovpw_settings_options', 'ovpw_section'); // id, title, display cb, page, section
    	add_settings_field('ovpw_header_color_field', 'Colore del testo dell\'header', array( $this, 'header_color_settings_field' ), 'ovpw_settings_options', 'ovpw_section' ); // id, title, display cb, page, section
    	add_settings_field('ovpw_body_bg_field', 'Colore di sfondo del corpo del widget', array($this, 'body_bg_settings_field'), 'ovpw_settings_options', 'ovpw_section'); // id, title, display cb, page, section
    	add_settings_field('ovpw_body_bg_secondary_field', 'Colore di sfondo secondario del corpo del widget', array($this, 'body_bg_secondary_settings_field'), 'ovpw_settings_options', 'ovpw_section'); // id, title, display cb, page, section
    	//add_settings_field( 'ovpw_body_separator_width_field', 'Spessore dei separatori', array( $this, 'body_separator_width_settings_field' ), 'ovpw_settings_options', 'ovpw_section' ); // id, title, display cb, page, section
    	//add_settings_field( 'ovpw_body_separator_color_field', 'Colore dei separatori', array( $this, 'body_separator_color_settings_field' ), 'ovpw_settings_options', 'ovpw_section' ); // id, title, display cb, page, section
    	add_settings_field('ovpw_body_success_box_bg_field', 'Colore di sfondo dei container relativi ai messaggi di riepilogo', array($this, 'body_success_box_bg_field'), 'ovpw_settings_options', 'ovpw_section'); // id, title, display cb, page, section
    	add_settings_field('ovpw_body_text_color', 'Colore del testo principale', array($this, 'body_text_color'), 'ovpw_settings_options', 'ovpw_section'); // id, title, display cb, page, section
    	add_settings_field('ovpw_body_secondary_text_color', 'Colore del testo secondario, ove presente', array($this, 'body_secondary_text_color'), 'ovpw_settings_options', 'ovpw_section' ); // id, title, display cb, page, section
    	add_settings_field('ovpw_body_boxed_text_color', 'Colore del testo dei box informativi', array($this, 'body_boxed_text_color'), 'ovpw_settings_options', 'ovpw_section' ); // id, title, display cb, page, section
    	add_settings_field('ovpw_body_buttons', 'Colore base dei pulsanti', array($this, 'body_button_color'), 'ovpw_settings_options', 'ovpw_section'); // id, title, display cb, page, section
    	add_settings_field('ovpw_body_module_buttons', 'Colore dei pulsanti azione dei moduli', array($this, 'body_module_button_color'), 'ovpw_settings_options', 'ovpw_section'); // id, title, display cb, page, section
    	add_settings_field('ovpw_body_buttons_text_color', 'Colore del testo nei pulsanti', array($this, 'body_button_text_color'), 'ovpw_settings_options', 'ovpw_section'); // id, title, display cb, page, section
    	register_setting('ovpw_settings_options', 'ovpw_settings_options', array($this, 'validate_options')); // option group, option name, sanitize cb
    }
    
    /**
     * Render colore Buttons
     * @access	public
     */
    public function body_button_text_color (){
    	$value = isset($this->options['body_button_text_color']) ? $this->options['body_button_text_color'] : '';
    	echo "<input type='text' name='ovpw_settings_options[body_button_text_color]' value='{$value}' class='ovpw-color-picker' />";
    }
    
    /**
     * Render campi colore / stile
     * @access	public
     */
    public function body_module_button_color (){
    	$value = isset($this->options['modulo_button_color']) ? $this->options['modulo_button_color'] : '';
    	echo "<input type='text' name='ovpw_settings_options[modulo_button_color]' value='{$value}' class='ovpw-color-picker' />";
    }
    
    /**
     * Render campi colore / stile
     * @access	public
     */
    public function body_button_color (){
    	$value = isset($this->options['body_button_color']) ? $this->options['body_button_color'] : '';
    	echo "<input type='text' name='ovpw_settings_options[body_button_color]' value='{$value}' class='ovpw-color-picker' />";
    }

    /**
     * Render campi colore / stile
     * @access	public
     */
    public function body_boxed_text_color (){
    	$value = isset($this->options['body_boxed_text_color']) ? $this->options['body_boxed_text_color'] : '';
    	echo "<input type='text' name='ovpw_settings_options[body_boxed_text_color]' value='{$value}' class='ovpw-color-picker' />";
    }
    
    /**
     * Render campi colore / stile
     * @access	public
     */
    public function body_secondary_text_color (){
    	$value = isset($this->options['body_secondary_text_color']) ? $this->options['body_secondary_text_color'] : '';
    	echo "<input type='text' name='ovpw_settings_options[body_secondary_text_color]' value='{$value}' class='ovpw-color-picker' />";
    }
    
    /**
     * Render campi colore / stile
     * @access	public
     */
    public function body_text_color (){
    	$value = isset($this->options['body_text_color']) ? $this->options['body_text_color'] : '';
    	echo "<input type='text' name='ovpw_settings_options[body_text_color]' value='{$value}' class='ovpw-color-picker' />";
    }
    
    /**
     * Render campi colore / stile
     * @access	public
     */
    public function body_success_box_bg_field (){
    	$value = isset($this->options['body_success_box_bg']) ? $this->options['body_success_box_bg'] : '';
    	echo "<input type='text' name='ovpw_settings_options[body_success_box_bg]' value='{$value}' class='ovpw-color-picker' />";
    }
    
    /**
     * Render campi colore / stile
     * @access	public
     */
	 /*
    public function body_separator_color_settings_field(){
    	echo '<input type="text" name="ovpw_settings_options[body_separator_color]" value="' . $this->options['body_separator_color'] . '" class="ovpw-color-picker" >';
    }
	*/
    
    /**
     * Render campi colore / stile
     * @access	public
     */
	 /*
    public function body_separator_width_settings_field(){
    	echo '<input type="number" name="ovpw_settings_options[body_separator_width]" value="' . $this->options['body_separator_width'] . '"> pixel';
    }
	*/
    
    /**
     * Render campi colore / stile
     * @access	public
     */
    public function body_bg_secondary_settings_field (){
    	$value = isset($this->options['body_background_secondary']) ? $this->options['body_background_secondary'] : '';
    	echo "<input type='text' name='ovpw_settings_options[body_background_secondary]' value='{$value}' class='ovpw-color-picker' />";
    }
    
    /**
     * Render campi colore / stile
     * @access	public
     */
    public function body_bg_settings_field (){
    	$value = isset($this->options['body_background']) ? $this->options['body_background'] : '';
    	echo "<input type='text' name='ovpw_settings_options[body_background]' value='{$value}' class='ovpw-color-picker' />";
    }
    
    /**
     * Render campi colore / stile
     * @access	public
     */
    public function id_vetrina_field (){
    	$value = isset($this->options['id_vetrina']) ? $this->options['id_vetrina'] : '';
    	echo "<input type='text' name='ovpw_settings_options[id_vetrina]' value='{$value}' />";
    	echo "<p>Codice Alfanumerico identificativo della vetrina su Overplace.com</p>";
    }
  
    /**
     * Render campi colore / stile
     * @access	public
     */
	public function file_settings_field (){
		$value = isset($this->options['file']) ? $this->options['file'] : '';
		echo "<input type='text' name='ovpw_settings_options[file]' value='{$value}' />";
		echo "<input type='button' id='button_carica_css' class='button' value='Carica / Scegli'>";
		echo "<p>Se carichi un file tutte i settaggi sottostanti non saranno efficaci. <a id='clear_css_file' href='#'>Pulisci File</a></p><br/>";
	}   
	
	/**
	 * Render campi colore / stile
	 * @access	public
	 */
	public function bg_settings_field (){
		$value = isset($this->options['background']) ? $this->options['background'] : '';
	    echo "<input type='text' name='ovpw_settings_options[background]' value='{$value}' class='ovpw-color-picker' />";
	}

	/**
	 * Render campi colore / stile
	 * @access	public
	 */
	public function header_bg_settings_field (){
		$value = isset($this->options['header_background']) ? $this->options['header_background'] : '';
		echo "<input type='text' name='ovpw_settings_options[header_background]' value='{$value}' class='ovpw-color-picker' />";
	}

	/**
	 * Render campi colore / stile
	 * @access	public
	 */
	public function header_color_settings_field (){
		$value = isset($this->options['header_color']) ? $this->options['header_color'] : '';
		echo "<input type='text' name='ovpw_settings_options[header_color]' value='{$value}' class='ovpw-color-picker' />";
	}
	
	/**
	 * Aggiunge un mime type per i file css all'interno dei mime types di Wordpress
	 * @access	public
	 * 
	 * @param 	array 	$mimes
	 * 
	 * @return 	array
	 */
	public function add_css_mime_types ($mimes){
		return array_merge($mimes, array('css' => 'css/stylesheet'));
	}
	
	/**
	 * Definisce il mime type dei css
	 * @access	public
	 * 
	 * @param 	array 	$post_mime_types
	 * 
	 * @return	array
	 */
	public function modify_css_mime_types ($post_mime_types){
		$post_mime_types['css'] = array(__('Css'), __('Amministra Css'), _n_noop('css <span class="count">(%s)</span>', 'Css Files <span class="count">(%s)</span>'));
		
		return $post_mime_types;
	}
	
	/**
	 * Auto-update del plugin
	 * @access	public
	 *
	public function ovp_widget_au (){
		$plugin_slug = plugin_basename(__FILE__);
		new overplace_widget_auto_update(self::current_version, self::self_hosted_url, $plugin_slug);
	}
	*/

	/**
	 * Estrae il css generato, distinguendo se si tratta di un file caricato o di un foglio di stile
	 * compilato dal plugin stesso.
	 * @access	private
	 * 
	 * @return 	string
	 */
	private function get_generated_css (){
		$css = '';
		$generated_css = get_option('ovpw_generated_css');
		if (!empty($this->options['file'])){
			$css = file_get_contents($this->options['file']);
		}else if (!empty($generated_css)){
			$css = file_get_contents($generated_css);
		}
		return $css;
	}
	
	/**
	 * Prima inizializzazione del plugin, recupero delle options di backup se presenti
	 * @access	public
	 */
	public function ovpw_register_plugin (){
		//controllo options di backup
		$ovpw_modules_options_bck = json_decode(unserialize(get_option('ovpw_modules_options_bck')), true);
		if (!empty($ovpw_modules_options_bck)){
			update_option('ovpw_modules_options', $ovpw_modules_options_bck);
			delete_option('ovpw_modules_options_bck');
		}else {
			$this->set_modules_default_option();
		}
		
		$ovpw_settings_options_bck = get_option('ovpw_settings_options_bck');
		if (!empty($ovpw_settings_options_bck)){
			update_option('ovpw_settings_options', $ovpw_modules_options_bck);
			delete_option('ovpw_settings_options_bck');
		}
		
		$ovpw_generated_css_bck = get_option('ovpw_generated_css_bck');
		if (!empty($ovpw_generated_css_bck)){
			update_option('ovpw_generated_css', $ovpw_generated_css_bck);
			delete_option('ovpw_generated_css_bck');
		}
		
	}
	
	/**
	 * Configura i valori di default per i diversi moduli renderizzati dai widgets
	 * @access	private
	 */
	private function set_modules_default_option (){
		$config = array(
			/*
			'ovp_lista_commenti' => array(
					'titolo' => 'Dicono di Noi',
					'descrizione' => 'Elenco delle nostre recensioni',
					'powered' => 1,
					'data_commento' => 1,
					'voto_commento' => 1
			),*/
			'ovp_lista_lista_commenti' => array(
				'titolo' => 'Dicono di Noi',
				'descrizione' => 'Elenco delle nostre recensioni',
				'powered' => 1,
				'data_commento' => 1,
				'voto_commento' => 1,
				'avatar_commento' => 1,
				'autore_commento' => 1
			),
			'ovp_lista_orari_servizi' => array(
				'titolo' => 'Orari e servizi offerti',
				'descrizione' => 'Orari di apertura e informazioni generali',
				'powered' => 1,
				'orari' => 1,
				'servizi' => 1,
				'pagamenti' => 1
			),
			'ovp_lista_newsletter' => array(
				'titolo' => 'Newsletter',
				'descrizione' => 'Iscriviti alla newsletter',
				'powered' => 1
			),
			'ovp_lista_menu' => array(
				'powered' => 1
			),
			'ovp_lista_catalogo' => array(
				'titolo' => 'Catalogo',
				'powered' => 1
			),
			'ovp_lista_ricetta' => array(
				'titolo' => 'Ricetta',
				'powered' => 1
			),
			'ovp_lista_storytelling' => array(
				'titolo' => 'Storytelling',
				'powered' => 1
			),
			'ovp_lista_news' => array(
				'titolo' => 'News',
				'descrizione' => 'Elenco delle ultime notizie',
				'powered' => 1,
				'immagine' => 1,
				'data' => 1,
				'lunghezza_testo' => ''
			),
			'ovp_lista_eventi' => array(
				'titolo' => 'Eventi',
				'descrizione' => 'Ho organizzato i seguenti eventi, partecipa!',
				'powered' => 1,
				'immagine' => 1,
				'data' => 1,
				'lunghezza_testo' => ''
			),
			'ovp_lista_promozioni' => array(
				'titolo' => 'Promozioni',
				'descrizione' => 'Usufruisci della nostra promozione',
				'powered' => 1
			),
			'ovp_lista_coupon' => array(
				'titolo' => 'Coupon',
				'descrizione' => 'Aggiudicati le nostre offerte shock!',
				'powered' => 1,
				'immagine' => 1
			),
			'ovp_lista_prenotazioni' => array(
				'titolo' => 'Prenotazioni',
				'powered' => 1
			),
			'ovp_lista_prenotazioni_hotel' => array(
				'titolo' => 'Prenotazioni Hotel',
				'powered' => 1
			),
			'ovp_lista_scrivi_recensioni' => array(
				'titolo' => 'Scrivi un commento',
				'powered' => 1
			),
			'ovp_lista_news_carousel' => array(
				'titolo' => 'News',
				'powered' => 1,
				'immagine' => 1,
				'number' => '',
				'lunghezza_testo' => '',
				'fancybox' => 0
			),
			'ovp_lista_gallery' => array(
				'titolo' => 'Galleria fotografica',
				'descrizione' => '',
				'powered' => 1,
				'type' => 'vetrina',
				'thumbnails' => 'xl',
				'number' => 0,
				'carousel_desktop' => 1,
				'carousel_mobile' => 1
			),
			'ovp_lista_meteo' => array(
				'titolo' => '',
				'descrizione' => '',
				'powered' => '1',
				'codice_istat' => ''
			),
			'ovp_lista_contatta_attivita' => array(
				'titolo' => 'Contattaci',
				'descrizione' => 'Contattaci per richiedere qualunque <strong>informazione</strong>, per un <strong>preventivo</strong> o per inviare il tuo <strong>curriculum</strong>.',
				'powered' => '1'
			)
		);
		update_option('ovpw_modules_options', serialize(json_encode($config)));
	}
	
	/**
	 * Popola le chiavi dell'impostazioni checkbox che con alcuni browser non
	 * vengono passate se non checked.
	 * @access	public
	 * 
	 * @param 	array	$post
	 * 
	 * @return	array
	 */
	public function filter_modules_vars ($post){
		/*
		if(!isset($post['ovpw_modules_options']['ovp_lista_commenti']['powered'])){
			$post['ovpw_modules_options']['ovp_lista_commenti']['powered'] = 0;
		}
		if(!isset($post['ovpw_modules_options']['ovp_lista_commenti']['data_commento'])){
			$post['ovpw_modules_options']['ovp_lista_commenti']['data_commento'] = 0;
		}
		if(!isset($post['ovpw_modules_options']['ovp_lista_commenti']['voto_commento'])){
			$post['ovpw_modules_options']['ovp_lista_commenti']['voto_commento'] = 0;
		}
		*/
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_menu']['powered'])){
			$post['ovpw_modules_options']['ovp_lista_menu']['powered'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_catalogo']['powered'])){
			$post['ovpw_modules_options']['ovp_lista_catalogo']['powered'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_ricetta']['powered'])){
			$post['ovpw_modules_options']['ovp_lista_ricetta']['powered'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_storytelling']['powered'])){
			$post['ovpw_modules_options']['ovp_lista_storytelling']['powered'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_orari_servizi']['powered'])){
			$post['ovpw_modules_options']['ovp_lista_orari_servizi']['powered'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_orari_servizi']['orari'])){
			$post['ovpw_modules_options']['ovp_lista_orari_servizi']['orari'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_orari_servizi']['servizi'])){
			$post['ovpw_modules_options']['ovp_lista_orari_servizi']['servizi'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_orari_servizi']['pagamenti'])){
			$post['ovpw_modules_options']['ovp_lista_orari_servizi']['pagamenti'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_news']['powered'])){
			$post['ovpw_modules_options']['ovp_lista_news']['powered'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_news']['immagine'])){
			$post['ovpw_modules_options']['ovp_lista_news']['immagine'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_news']['data'])){
			$post['ovpw_modules_options']['ovp_lista_news']['data'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_eventi']['powered'])){
			$post['ovpw_modules_options']['ovp_lista_eventi']['powered'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_eventi']['immagine'])){
			$post['ovpw_modules_options']['ovp_lista_eventi']['immagine'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_eventi']['data'])){
			$post['ovpw_modules_options']['ovp_lista_eventi']['data'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_promozioni']['powered'])){
			$post['ovpw_modules_options']['ovp_lista_promozioni']['powered'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_coupon']['immagine'])){
			$post['ovpw_modules_options']['ovp_lista_coupon']['immagine'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_coupon']['powered'])){
			$post['ovpw_modules_options']['ovp_lista_coupon']['powered'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_prenotazioni']['powered'])){
			$post['ovpw_modules_options']['ovp_lista_prenotazioni']['powered'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_prenotazioni_hotel']['powered'])){
			$post['ovpw_modules_options']['ovp_lista_prenotazioni_hotel']['powered'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_prenotazioni_hotel']['immagine'])){
			$post['ovpw_modules_options']['ovp_lista_prenotazioni_hotel']['immagine'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_newsletter']['powered'])){
			$post['ovpw_modules_options']['ovp_lista_newsletter']['powered'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_lista_commenti']['powered'])){
			$post['ovpw_modules_options']['ovp_lista_lista_commenti']['powered'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_lista_commenti']['data_commento'])){
			$post['ovpw_modules_options']['ovp_lista_lista_commenti']['data_commento'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_lista_commenti']['voto_commento'])){
			$post['ovpw_modules_options']['ovp_lista_lista_commenti']['voto_commento'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_lista_commenti']['autore_commento'])){
			$post['ovpw_modules_options']['ovp_lista_lista_commenti']['autore_commento'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_lista_commenti']['avatar_commento'])){
			$post['ovpw_modules_options']['ovp_lista_lista_commenti']['avatar_commento'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_scrivi_recensioni']['powered'])){
			$post['ovpw_modules_options']['ovp_lista_scrivi_recensioni']['powered'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_news_carousel']['powered'])){
			$post['ovpw_modules_options']['ovp_lista_news_carousel']['powered'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_news_carousel']['immagine'])){
			$post['ovpw_modules_options']['ovp_lista_news_carousel']['immagine'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_news_carousel']['fancybox'])){
			$post['ovpw_modules_options']['ovp_lista_news_carousel']['fancybox'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_gallery']['powered'])){
			$post['ovpw_modules_options']['ovp_lista_gallery']['powered'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_gallery']['thumbnails'])){
			$post['ovpw_modules_options']['ovp_lista_gallery']['thumbnails'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_gallery']['number'])){
			$post['ovpw_modules_options']['ovp_lista_gallery']['number'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_gallery']['carousel_desktop'])){
			$post['ovpw_modules_options']['ovp_lista_gallery']['carousel_desktop'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_gallery']['carousel_mobile'])){
			$post['ovpw_modules_options']['ovp_lista_gallery']['carousel_mobile'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_meteo']['powered'])){
			$post['ovpw_modules_options']['ovp_lista_meteo']['powered'] = 0;
		}
		
		if (!isset($post['ovpw_modules_options']['ovp_lista_contatta_attivita']['powered'])){
			$post['ovpw_modules_options']['ovp_lista_contatta_attivita']['powered'] = 0;
		}
		
		return $post;
	}
	
	/**
	 * Actin chiamata in fase di disattivazione / aggiornamento plugin, crea un backup delle option 
	 * e poi le cancella
	 * @access	public
	 */
	public function ovpw_unregister_plugin ($delete_options = true){
		if (!empty($this->modules_options)){
			update_option('ovpw_modules_options_bck', $this->options);
		}
		
		if (!empty($this->options)){
			update_option('ovpw_settings_options_bck', serialize(json_encode($this->modules_options)));
		}
		
		$generated_css = get_option('ovpw_generated_css');
		
		if (!empty($generated_css)){
			update_option('ovpw_generated_css_bck', $generated_css);
		}
		
		delete_option('ovpw_modules_options');
		delete_option('ovpw_settings_options');
		delete_option('ovpw_generated_css');
	}
	
} 
  
//let's play
Overplace_Widget_Options::get_instance();

?>