<?php

class css_generator{
	
	public $output;
	
	private $css_collection = array();
		
	public function __construct($params){
		$this->genera_css($params);
	}
	
	private function genera_css($params){
		foreach($params as $key => $val){
			if(method_exists($this,'add_css_'.$key)){
				$this->{'add_css_'.$key}($val)."\n";
			}			
		}	
		if(!empty($this->css_collection)){
			$this->output = self::parse_css($this->css_collection);
		}
	}
	
	/**
	 * Body Background
	 * @param unknown $val
	 */
	private function add_css_background($val){
		 $this->prepare_css(
						array(
							'body' => array('background-color' => $val.' !important')
							)
					);
	}

	/**
	 * Background testata
	 * @param unknown $val
	 */
	private function add_css_header_background($val){
		$this->prepare_css(
						array(
							'.widget_container .widget_header' 									=> array('background-color' => $val),
							'.widget_container .barra_form_registrazione, .barra_form_login' 	=> array('background-color' => $val),
							'.widget_header' 													=> array('background-color' => $val.' !important'),
							'.box-container-header' 											=> array('background-color' => $val.' !important'),
							'#box-testata-catalogo' 											=> array('background-color' => $val.' !important'),
							'#box-booking .box-campi-booking' 									=> array('background-color' => $val.' !important'),
							'#box-prenotazioni .step-tabs' 										=> array('background-color' => $val.' !important'),
							'#box-eventi .box-eventi-calendar-top' 								=> array('background-color' => $val.' !important', 'border-bottom-color' => $val),
							)
					);
	}

	/**
	 * Colore testo header
	 * @param unknown $val
	 */
	private function add_css_header_color($val){
		$this->prepare_css(
						array(
							'.widget_container .barra_form_registrazione .head_box, .barra_form_login .head_box' 	=> array('color' => $val),
							'.widget_header' 																		=> array('color' => $val.' !important'),
							'.box-container-header p' 																=> array('color' => $val.' !important'),
							'.box-container-header span.fa, #box-testata-catalogo'  								=> array('color' => $val.' !important')
						)
					);
	}
	
	/**
	 * Background box widget
	 * @param unknown $val
	 */
	private function add_css_body_background($val){
		$this->prepare_css(
				array(
						'.widget_container .widget_content' 				=> array('background-color' => $val),
						'.widget_container' 								=> array('background-color' => $val),
						'.widget_box_content table'							=> array('background-color' => $val),
						'.box-container-content'							=> array('background-color' => $val)
				)
		);
	}
	
	/**
	 * Colore secondario background widget - colore righe alternate
	 * @param unknown $val
	 */
	private function add_css_body_background_secondary($val){
		$this->prepare_css(
				array(
						'.widget_content .riga_hotel_camera' 							=> array('background-color' => $val),
						'.widget_content .riepilogo_prenotazione'						=> array('background-color' => $val),
						'.widget_box_content table'										=> array('background-color' => $val),
						'.widget_box_content table tr.grigio'							=> array('background-color' => $val),
						'.widget_box_content .riga_content #coupon_dettaglio' 			=> array('background-color' => $val),
						'#box_prenotazione_completata .container_riepilogo'				=> array('background-color' => $val),
						'#box_prenotazione_completata .container_riepilogo_left' 		=> array('background-color' => $val),
						'#box_prenotazione_completata .container_riepilogo_right' 		=> array('background-color' => $val),
						'.widget_box_content .riga_commento.grigio'						=> array('background-color' => $val),
						'.l_bar'														=> array('background' => 'none repeat scroll 0 0 '.$val),
						'.panel-group .panel'											=> array('background-color' => $val),
						'.box-dati-ricetta .box-dati-ricetta-text'						=> array('background-color' => $val.' !important'),
						'#box-lista-storytelling .owl-carousel .item:hover'				=> array('background-color' => $val.' !important'),
						'#box-storytelling #box-storytelling-dettaglio'					=> array('background-color' => $val.' !important'),
						'#box-offerte #box-container-promozioni .numero_checkin'		=> array('background-color' => $val.' !important', 'border-color' => $val),
						'#box-offerte #box-container-promozioni .descrizione_checkin'	=> array('border-color' => $val),
						'#box-coupon .countdown'										=> array('background-color' => $val.' !important')
				)
		);
	}
	
	/**
	 * Larghezza dei separatori all'interno dei box
	 * @param unknown $val
	 */
	/*
	private function add_css_body_separator_width($val){
		$this->prepare_css(
				array(
						'#news .riga' => array('border-bottom' => $val.'px solid'),
						'.widget_content .riga_prenotazione_servizio' => array('border-bottom' => $val.'px solid'),
						'.widget_content .riga_prenotazione_giorno, .widget_content .riga_prenotazione_orario' => array('border-bottom' => $val.'px solid'),
						'.widget_content .riga_prenotazione_orario' => array('border-bottom' => $val.'px solid'),
						'.widget_content .container_riepilogo_codice' => array('border-bottom' => $val.'px solid', 'border-top' => $val.'px solid'),
						'.widget_content #riepilogo_disponibilita' => array('border-top' => $val.'px solid'),
						'.widget_content .riga_hotel_camera .info_camera' => array('border-right' => $val.'px solid'),
						'.widget_content .dettaglio_camera .dati_camera' => array('border-bottom' => $val.'px solid'),
						'.widget_content .riepilogo_prenotazione_top' => array('border-bottom' => $val.'px solid'),
						'.widget_content .riepilogo_prenotazione .riepilogo_prezzi' => array('border-left' => $val.'px solid'),
						'.widget_content .riepilogo_prenotazione .riepilogo_condizioni .lista_condizioni' => array('border-bottom' => $val.'px solid'),
						'table tr.grigio td' => array('border-top' => $val.'px solid'),
						'.widget_box_content .show_offerta_checkin'	=> array('border-bottom' => $val.'px solid'),
						'.widget_box_content #coupon_dettaglio hr'	=> array('height' => $val.'px'),
						'.widget_box_content .riga_commento'=> array('border-bottom' => $val.'px solid'),
						'#box-ricetta .ricetta-separator' => array('height' => $val.'px')
				)
		);
	}
	*/
	/**
	 * Colori dei separatori all'interno dei box
	 * @param unknown $val
	 */
	/*
	private function add_css_body_separator_color($val){
		$this->prepare_css(
				array(
						//NEWS
						'#news .riga' => array('border-color' => $val),
						//PRENOTAZIONI
						'.widget_content .riga_prenotazione_servizio' => array('border-color' => $val),
						'.widget_content .riga_prenotazione_giorno, .widget_content .riga_prenotazione_orario' => array('border-color' => $val),
						'.widget_content .riga_prenotazione_orario' => array('border-color' => $val),
						'.widget_content .container_riepilogo_codice' => array('border-color' => $val),
						//HOTEL
						'.widget_content #riepilogo_disponibilita' => array('border-color' => $val),
						'.widget_content .riga_hotel_camera .info_camera' => array('border-color' => $val),
						'.widget_content .dettaglio_camera .dati_camera' => array('border-color' => $val),
						'.widget_content .riepilogo_prenotazione_top' => array('border-color' => $val),
						'.widget_content .riepilogo_prenotazione .riepilogo_prezzi' => array('border-color' => $val),
						'.widget_content .riepilogo_prenotazione .riepilogo_condizioni .lista_condizioni' => array('border-color' => $val),
						//ORARI
						'table tr.grigio td' => array('border-color' => $val.'px solid'),
						//PROMOZIONI
						'.widget_box_content .show_offerta_checkin'	=> array('border-color' => $val),
						//COUPON
						'.widget_box_content #coupon_dettaglio hr'	=> array('background-color' => $val),
						//Ricettta
						'#box-ricetta .ricetta-separator' => array('background-color' => $val.' !important')
				)
		);
	}
	*/
	/**
	 * Colore background box colorati (Riepilogo prenotazione / offerrta checkin)
	 * @param unknown $val
	 */
	private function add_css_body_success_box_bg($val){
		$this->prepare_css(
				array(
						'#box_riepilogo_prenotazione.widget_content .container_riepilogo' => array('background-color' => $val, 'opacity' => '0.6', 'border' => '1px solid '.$val),
						'.widget_box_content .show_offerta_checkin h3' => array(
								'background-color' => $val, 
								'opacity' => '0.6', 
								'border' => '1px solid '.$val
						),
						'#box-prenotazioni .prenotazione-success blockquote' => array('background-color' => $val)
				)
		);
	}
	
	/**
	 * Colore del testo generico all'interno del content
	 * @param unknown $val
	 */
	private function add_css_body_text_color($val){
		$this->prepare_css(
				array(
						'.widget_content' => array('color' => $val),
						'.widget_container .widget_content .widget_box_footer .widget_paginazione .attivo' => array('color' => $val),
						'#box_riepilogo_prenotazione.widget_content p'  => array('color' => $val),
						'.box-container-content.widget_content' => array('color' => $val.' !important'),
						'.box-container-content' => array('color' => $val.' !important'),
						
				)
		);
	}
	
	/**
	 * Colore testo secondario
	 * @param unknown $val
	 */
	private function add_css_body_secondary_text_color($val){
		$this->prepare_css(
				array(
						'.widget_content .riga_hotel_camera .info_camera h4' 											=> array('color' => $val),
						'.widget_content .riepilogo_prenotazione .riepilogo_hotel h4' 									=> array('color' => $val),
						'.widget_content .dettaglio_camera .lista_condizioni p strong' 									=> array('color' => $val),
						'.widget_content .colonna h4' 																	=> array('color' => $val),
						'.widget_content .riga_prenotazione_orario h4' 													=> array('color' => $val),
						'.widget_content .container_riepilogo_codice h4' 												=> array('color' => $val),
						'.widget_box_content .riga_content h3, .widget_box_content #coupon_dettaglio h2' 				=> array('color' => $val),
						'.widget_container .form_container label span.label_title' 										=> array('color' => $val),
						'.widget_box_content .riga_titolo h1' 															=> array('color' => $val),
						'.link_evento a' 																				=> array('color' => $val),
						'#contenuto-menu .panel-default.categoria > .panel-heading > h4.panel-title a' 					=> array('color' => $val),
						'#contenuto-menu h4.panel-title p'																=> array('color' => $val),
						'span.ricetta_ingredienti_titolo, span.ricetta_allergeni_titolo , span.ricetta_allegato_titolo' => array('color' => $val.' !important'),
						'.storytelling_titolo h5' 																		=> array('color' => $val.' !important'),
						'#box-contenuto-catalogo ol.breadcrumb > li' 													=> array('color' => $val.' !important'),
						'#box-post .riga_post_bacheca .post_bacheca_testo p' 											=> array('color' => $val.' !important'),
						'#box-newsletter .form-horizontal .checkbox label' 												=> array('color' => $val.' !important'),
						'#box-offerte #box-container-promozioni .numero_checkin p'										=> array('color' => $val.' !important'),
						'#box-offerte #box-container-promozioni .numero_checkin span'									=> array('color' => $val.' !important'),
						'#box-coupon .countdown p'																		=> array('color' => $val.' !important'),
						'#countdown .time_circles > div > h4'															=> array('color' => $val.' !important'),
						'#countdown .time_circles > div > h4, #countdown .time_circles > div > span'					=> array('color' => $val.' !important')
				)
		);
	}
	
	/**
	 * Colore testo box colorati (prenotazioni / checkin)
	 * @param unknown $val
	 */
	private function add_css_body_boxed_text_color($val){
		$this->prepare_css(
				array(
					'#box_riepilogo_prenotazione.widget_content p' 				=> array('color' => $val),
					'.widget_box_content .show_offerta_checkin h3' 				=> array('color' => $val),
					'#box-ricetta .box-dati-ricetta-value' 						=> array('background-color' => $val.' !important'),
					'#box-prenotazioni .riepilogo blockquote' 					=> array('background-color' => $val, 'opacity' => '0.6', 'border' => '1px solid '.$val),
					'#box-prenotazioni .riepilogo blockquote'       			=> array('background-color' => $val.' !important'),
					'#box-scrivi-recensioni #box-inserisci-commenti blockquote' => array('background-color' => $val.' !important')
				)
		);
	}
	
	/**
	 * Colore dei pulsanti di base
	 * @param unknown $val
	 */
	private function add_css_body_button_color($val){
		$this->prepare_css(
				array(
						'.widget_container .form_container input[type="button"]' 									=> array('background-color' => $val, 'background-image' => 'none'),
						'.widget_container .form_container input[type="button"]:hover' 								=> array('background-color' => $val, 'background-image' => 'none'),
						'.widget_container .container_pulsanti .btn' 												=> array('background-color' => $val, 'background-image' => 'none'),
						'.widget_container .container_pulsanti .btn:hover' 											=> array('background-color' => $val, 'background-image' => 'none'),
						'.widget_container .widget_content .widget_box_footer .btn_paging' 							=> array('background-color' => $val, 'background-image' => 'none'),
						'.widget_container .widget_content .widget_box_footer .widget_paginazione .attivo:hover'  	=> array('background-color' => $val.' !important', 'background-image' => 'none !important'),
						'#box-ricetta .allegato_ricetta' 															=> array('background-color' => $val.' !important'),
						'.owl-carousel .open_storyrelling, .btn.close_storyrelling' 								=> array('background-color' => $val.' !important'),
						'#box-catalogo .btn' 																		=> array('background-color' => $val.' !important'),
						'#box-recensioni #paging-commenti li > a' 													=> array('background-color' => $val),
						'#box-scrivi-recensioni .btn' 																=> array('background-color' => $val),
						'#box-ricetta .allegato_ricetta'															=> array('background-color' => $val),
						'#box-storytelling #box-container-storytelling div.btn'										=> array('background-color' => $val),
						'#box-menu #contenuto-menu .bottoni-download span'											=> array('background-color' => $val)
				)
		);
	}
	
	/**
	 * Colore pulsanti collegati ad azioni dei moduli
	 */
	private function add_css_modulo_button_color($val){
		$this->prepare_css(
				array(
						'.widget_container .widget_content .btn_azione p' 			=> array('background-color' => $val, 'background-image' => 'none'),
						'.widget_content .maggiori_info' 							=> array('background-color' => $val, 'border-bottom' => $val, 'opacity' => '0.65'),
						'.widget_container .btn_submit'								=> array('background-color' => $val, 'background-image' => 'none'),
						'#box-catalogo .box-categoria-catalogo' 					=> array('background-color' => $val.' !important'),
						'#box-scrivi-recensioni .btn' 								=> array('background-color' => $val.' !important'),
						'#box-booking #button_disponbilita' 						=> array('background-color' => $val.' !important'),
						'#box-coupon a.btn' 										=> array('background-color' => $val.' !important'),
						'#box-eventi #box-eventi-calendar .event span.badge-event' 	=> array('background-color' => $val),
						'#box-newsletter #box-newsletter-form button.btn'			=> array('background-color' => $val),
						'#box-prenotazioni button.btn'								=> array('background-color' => $val)
				)
		);
	}
	
	private function add_css_body_button_text_color($val){
		$this->prepare_css(
				array(
						'.widget_container .form_container input[type="button"]' 							=> array('color' => $val),
						'.widget_container .widget_content .widget_box_footer .widget_paginazione .attivo' 	=> array('color' => $val),
						'.widget_container .container_pulsanti .btn'										=> array('color' => $val),
						'.widget_container .btn_submit' 													=> array('color' => $val),
						'.widget_container .widget_content .btn_azione p' 									=> array('color' => $val),
						'#box-ricetta .allegato_ricetta' 													=> array('color' => $val.' !important'),
						'.owl-carousel .open_storyrelling, .btn.close_storyrelling' 						=> array('color' => $val.' !important'),
						'#box-catalogo .btn' 																=> array('color' => $val.' !important'),
						'#box-catalogo .box-categoria-catalogo' 											=> array('color' => $val.' !important'),
						'#box-recensioni #paging-commenti li > a' 											=> array('color' => $val.' !important'),
						'#box-scrivi-recensioni .btn' 														=> array('color' => $val.' !important'),
						'#box-booking button.btn-booking' 													=> array('color' => $val.' !important'),
						'#box-prenotazioni .btn' 															=> array('color' => $val.' !important'),
						'#box-menu #contenuto-menu .bottoni-download span'									=> array('color' => $val)
				)
		);
	}
	
	private function prepare_css($params){
		foreach($params as $element => $arr_style){
			foreach($arr_style as $key => $val){
				$this->css_collection[$element][] = $key.':'.$val.'; ';
			}
		}
	}
	 
	private static function parse_css($data){
		$rstring = '';
		foreach($data as $element => $arr_style){
			$rstring.= $element.'{';
			$nr = count($arr_style);
			for($i = 0; $i < $nr; $i++){
				$rstring.= $arr_style[$i];
			}
			
			$rstring.= '}'."\n";
		}
		return $rstring;
	}	
}